LRFSerial = LRFWebcore.serial;
LRFComm = LRFWebcore.comm;
LRFColor = LRFWebcore.types.LRFColor;
LRFMessages = LRFWebcore.messages;
LRFEvents = LRFWebcore.events;
LRFRobotModel = LRFWebcore.model;

//Tell the serial library to look for and unpack messages when data is received
LRFSerial.setReceiveCallback(function(receivedBuffer) {
  LRFComm.unpack(receivedBuffer);
});

//When a robot connects...
LRFEvents.on(LRFSerial.EVENT.CONNECTED, () => {
  //Place code you want to run after a connection is established here.
  // LRFComm.send(LRFMessages.setControlMode(2));
  console.log("CONNECTING with control mode 3");
  LRFComm.send(LRFMessages.setControlMode(3)); // <-- sensor mode

  // //If connection successful set robot's eyes red to notify connection success
  // var setEyesRed = LRFMessages.eyesSetColors(LRFColor.red, LRFColor.red);
  // LRFComm.send(setEyesRed);
  //
  // //After 3 seconds turn the eyes off
  // var setEyesOff = LRFMessages.eyesSetColors(LRFColor.none, LRFColor.none);
  // setTimeout(function() {
  //   LRFComm.send(setEyesOff);
  // }, 3000);
});

LRFEvents.on(LRFSerial.EVENT.DISCONNECTED, () => {
  LRFSerial.autoConnect();
});

//Setup our serial connection
LRFSerial.setup(process.platform, "node")
  .then(function() {
    console.log("SETUP SERIAL WITH NODE");
    //Look for and connect to robots
    LRFSerial.autoConnect();
  })
  .catch(err => {
    console.error(err);
  });
